<?php

namespace App\Observers;

use App\Entities\Permission;
use Illuminate\Support\Facades\Cache;

class PermissionObserver
{
    /**
     * Handle the permission "created" event.
     *
     * @param  Permission  $permission
     * @return void
     */
    public function created(Permission $permission)
    {
        Cache::tags(['ListaPermissoes'])->flush();
    }

    /**
     * Handle the permission "updated" event.
     *
     * @param  Permission  $permission
     * @return void
     */
    public function updated(Permission $permission)
    {
        Cache::tags(['ListaPermissoes'])->flush();
    }

    /**
     * Handle the permission "deleted" event.
     *
     * @param  Permission  $permission
     * @return void
     */
    public function deleted(Permission $permission)
    {
       Cache::tags(['ListaPermissoes'])->flush();
    }

    /**
     * Handle the permission "restored" event.
     *
     * @param  Permission  $permission
     * @return void
     */
    public function restored(Permission $permission)
    {
       Cache::tags(['ListaPermissoes'])->flush();
    }

    /**
     * Handle the permission "force deleted" event.
     *
     * @param  Permission  $permission
     * @return void
     */
    public function forceDeleted(Permission $permission)
    {
       Cache::tags(['ListaPermissoes'])->flush();
    }
}
