<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\ImpressoraRepository;
use App\Entities\Nati\Impressora;
use App\Validators\Nati\ImpressoraValidator;

/**
 * Class ImpressoraRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class ImpressoraRepositoryEloquent extends BaseRepository implements ImpressoraRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Impressora::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ImpressoraValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
