<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\printsRepository;
use App\Entities\Prints;
use App\Validators\PrintsValidator;

/**
 * Class PrintsRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class PrintsRepositoryEloquent extends BaseRepository implements PrintsRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Prints::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return PrintsValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
