<?php

namespace App\Services;

use App\Entities\EntradaSaida;
use App\Entities\Financeiro\SubGrupo;
use App\Repositories\EntradaSaidaRepository;
use App\Validators\EntradaSaidaValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class EntradaSaidaService
{
    private $repository;
    private $validator;

    public function __construct(EntradaSaidaRepository $repository,EntradaSaidaValidator $validator)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));

    }

    public function get()
    {
        $entradaSaidas = $this->repository->all();

        return $entradaSaidas;
    }
    public function getById($id)
    {

        $entradaSaidas = $this->repository->find($id);

        return $entradaSaidas;
    }

    public function insert($data) {

        if ($this->repository->all()->last()){
            $idCategoriaConta = $this->repository->all()->last()->idCategoriaConta;
        }else{
            $idCategoriaConta = 0;
        }

        $data = [
            'idCategoriaConta' => $idCategoriaConta + 1,
            'stCategoriaConta' => $data['stCategoriaConta'],
            'dtAlteracao' => Carbon::now()
        ];
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($data);
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        $hasSub = SubGrupo::all()->where('idCategoriaConta', $id);

        if (!count($hasSub)) return $this->repository->delete($id);
        else return false;

    }

}
