<?php

namespace App\Services\Nati;

use App\Entities\Nati\ExportProductsScale\FileGeneratorMGV7;
use App\Entities\Nati\Product;
use App\Entities\Nati\ExportProductsScale\ExportProducts;
use App\Entities\Nati\ExportProductsScale\FileGeneratorMGV5;
use App\Entities\Nati\ExportProductsScale\FileGeneratorMGV6;
use App\Entities\Nati\ExportProductsScale\FileGeneratorFilizola;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class BalanceProductsService
{
    public function __construct()
    {

    }
    public function getProductsBalance($request)
    {
        $filter = $request->filter;
        $value = $request->value;

        $products = Product::selectRaw(
            'prd_produtos.idProduto as id,
            MIN(prd_codigos.idCodigo) as codigo,
            prd_produtos.stProduto as descricao,
            prd_produtos.flBalanca,
            prd_medidas.stMedida as medida'
        )
                            ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_codigos.idProduto')
                            ->join('prd_medidas', 'prd_produtos.idMedida', '=', 'prd_medidas.idMedida')
                            ->where('prd_produtos.flAtivo', true)
                            ->where("prd_produtos.id".$filter, $value)
                            ->groupBy(['prd_produtos.idProduto',
                            'prd_produtos.stProduto',
                            'prd_produtos.flBalanca',
                            'prd_medidas.stMedida'
                            ])
                            ->paginate($request->limit, $request->page);

        return $products;
    }

    public function filterProducts($request)
    {
        $value = $request->value;

        $products = Product::selectRaw(
            'prd_produtos.idProduto as id,
            MIN(prd_codigos.idCodigo) as codigo,
            prd_produtos.stProduto as descricao,
            prd_produtos.flBalanca,
            prd_medidas.stMedida as medida'
        )
                            ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_codigos.idProduto')
                            ->join('prd_medidas', 'prd_produtos.idMedida', '=', 'prd_medidas.idMedida')
                            ->where('prd_produtos.flAtivo', true)
                            // ->where("prd_produtos.stProduto", 'LIKE', "%.$value.%")
                            ->where(function ($query) use ($value) {
                                    $query->where('idCodigo', 'LIKE', "%{$value}%")
                                        ->orWhere('stProduto', 'LIKE', "%{$value}%");
                            })
                            ->groupBy(['prd_produtos.idProduto',
                            'prd_produtos.stProduto',
                            'prd_produtos.flBalanca',
                            'prd_medidas.stMedida'
                            ])
                            ->paginate($request->limit, $request->page);

        return $products;
    }

    public function getAllProductsBalance($request)
    {
        $products = Product::selectRaw(
            'prd_produtos.idProduto as id,
            MIN(prd_codigos.idCodigo) as codigo,
            prd_produtos.stProduto as descricao,
            prd_produtos.flBalanca,
            prd_medidas.stMedida as medida'
        )
                            ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_codigos.idProduto')
                            ->join('prd_medidas', 'prd_produtos.idMedida', '=', 'prd_medidas.idMedida')
                            ->where('prd_produtos.flAtivo', true)
                            ->where("prd_produtos.flBalanca", true)
                            ->groupBy(['prd_produtos.idProduto',
                            'prd_produtos.stProduto',
                            'prd_produtos.flBalanca',
                            'prd_medidas.stMedida'
                            ])
                            ->paginate($request->limit, $request->page);
        return $products;
    }

    public function getProductsIds()
    {
        $result = Product::select('idProduto')
                    ->where('flAtivo', true)
                    ->where('flBalanca', true)
                    ->get();


        return $result;
    }
    public function countProductsBalance()
    {
        $count = Product::where('flAtivo', true)
                        ->where('flBalanca', true)
                        ->count();

        return $count;
    }
    public function updateProductsBalance($data)
    {
        foreach($data as $item) {
            $product = Product::find($item['id']);
            $product->update([
                'flBalanca' => $item['flBalanca']
            ]);
        }

        return true;
    }
    public function generateFiles($request)
    {
        $request['productsIds'] = $this->getProductsIds();

        if($request['modelFile'] == 'MGV5') {
            $export = new ExportProducts($request, new FileGeneratorMGV5());
            $export->generateFiles();
        }
        if($request['modelFile'] == 'MGV6') {
            $export = new ExportProducts($request, new FileGeneratorMGV6());
            $export->generateFiles();
        }
        if($request['modelFile'] == 'MGV7') {
            $export = new ExportProducts($request, new FileGeneratorMGV7());
            $export->generateFiles();
        }
        if($request['modelFile'] == 'Filizola') {
            $request['nutritionalInformation'] = false;
            $request['additionalInformation'] = false;
            $export = new ExportProducts($request, new FileGeneratorFilizola());
            $export->generateFiles();
        }
    }

    public function downloadFiles($file)
    {
        $path  = Storage::path($file);
        return response()->file($path);
    }
}
