<?php

namespace App\Services\Nati;

use App\Entities\Nati\GerenciadorDetalhes;
use App\Repositories\HistoricoFechamentoRepository;
use App\Repositories\Nati\GerenciadorDetalhesRepository;
use App\Services\Service;
use App\Validators\Nati\GerenciadorDetalhesValidator;
use Carbon\Carbon;

class FechamentoService extends Service
{

    protected $validator;
    protected $repository;
    protected $historicRepository;
    protected $user;

    public function __construct(GerenciadorDetalhesValidator $validator, GerenciadorDetalhesRepository $repository,
                                HistoricoFechamentoRepository $historicRepository)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->historicRepository = $historicRepository;
    }

    public function insertDetails($idAbertura, $details)
    {
        $hasDetails = $this->repository->findWhere(['idAbertura' => $idAbertura]);
        if($hasDetails->count() > 0){
            return true;
        }
        $id_detail = $this->getNextId();
        $date = Carbon::now();
        // TODO remover quando o fechamento estiver 100% refatorado
        $idOperador = auth()->id() ? auth()->id() : $details['idOperador'];
        foreach ((array)$details['detalhesPagamento'] as $detail) {

            $data = [
                'idAbertura' => $idAbertura,
                'idFormaPagamento' => $detail['idFormaPagamento'],
                'idDetalhe' => $id_detail,
                'vrPagamento' => $detail['nAtual'],
                'idOperador' => $idOperador,
                'vrPagamentoMicro' => $detail['xAtual'],
                'flPendente' => true,
                'dtAlteracao' => $date,
            ];
            $this->repository->create($data);
        }
        return true;
    }

    public function insertHistoric($id_open, $historic)
    {
        $date = Carbon::now();
        $data = [
            'idAbertura' => $id_open,
            'vrApurado' => (float)$historic['vrApurado'],
            'vrFechamento' => (float)$historic['vrFechamento'],
            'vrDiferenca' => number_format($historic['vrDiferenca'], '2', '.', ''),
            'dtData' => $date,
            'dtAlteracao' => $date
        ];
        return $this->historicRepository->create($data);
    }

    private function getNextId()
    {
        return GerenciadorDetalhes::max('idDetalhe') + 1;
    }

}
