<?php


namespace App\Services;

use App\Validators\NfeValidator;
use Illuminate\Support\Facades\Storage;
use NFePHP\Common\Certificate;
use NFePHP\NFe\Make;
use NFePHP\NFe\Tools;
use stdClass;

class NfeService
{
    private $nfe;

    public function __construct(NfeValidator $validator)
    {
        $this->validator = $validator;
        $this->nfe = new Make();
    }

    public function gerarNfe()
    {
        $this->createInfNfe();
        $this->createIde();
        $this->createEmit();
        $this->createDest();
        $this->createProd();
        $this->createTotal();
        $this->createTransp();
        $this->createFatura();

        $xml = $this->nfe->getXML(); // O conteúdo do XML fica armazenado na variável $xml

        $cert = file_get_contents('D:\www\Arcnet\nati2\api\storage\arcnet_2018.pfx');
        $tools = new Tools($this->getConfig(), Certificate::readPfx($cert,'arc311625'));

        try{
            $xmlAssinado = $tools->signNFe($xml);
        } catch(\Exception $e){
            exit($e->getMessage());
        }
    }

    private function createInfNfe(){
        $std = new \stdClass();
        $std->versao = '4';

        $this->nfe->taginfNFe($std);
    }

    private function createIde(){
        $std = new \stdClass();
        $std->cUF = 35;
        $std->cNF = '17312199';
        $std->natOp = 'CFOP 6101 VENDA DE PRODUCAO DO ESTABELECIMENTO';
        $std->indPag = 0; //NÂO EXISTE EM 4.00
        $std->mod = 55;
        $std->serie = 1;
        $std->nNF = 7104;
        $std->dhEmi = '2018-07-24T11:31:31-03:00';
        $std->dhSaiEnt = '2018-07-24T11:31:31-03:00';
        $std->tpNF = 1;
        $std->idDest = 2;
        $std->cMunFG = 3550308;
        $std->tpImp = 1;
        $std->tpEmis = 1;
        $std->cDV = 2;
        $std->tpAmb = 2; // Se deixar o tpAmb como 2 você emitirá a nota em ambiente de homologação(teste) e as notas fiscais aqui não tem valor fiscal
        $std->finNFe = 1;
        $std->indFinal = 1;
        $std->indPres = 0;
        $std->procEmi = 'NatiNFe 4.0.0.0';
        $std->verProc = 1;
        $this->nfe->tagide($std);
    }

    private function createEmit(){
        $std = new \stdClass();
        $std->xNome = 'ARCNET DESENVOLVIMENTO DE SOFTWARE LTDA - ME';
        $std->IE = '148163727111';
        $std->CRT = 1;
        $std->CNPJ = '09000003000108';
        $this->nfe->tagemit($std);

        $std = new \stdClass();
        $std->xLgr = "rua jose bonifacio";
        $std->nro = '112';
        $std->xBairro = 'Boa Vista';
        $std->cMun = '3548807';
        $std->xMun = 'sao caetano do sul';
        $std->UF = 'sp';
        $std->CEP = '09572050';
        $std->cPais = '1058';
        $std->xPais = 'BRASIL';
        $this->nfe->tagenderEmit($std);
    }

    private function createDest(){
        $std = new \stdClass();
        $std->xNome = 'Empresa destinatário teste';
        $std->indIEDest = 1;
        $std->IE = '6564344535';
        $std->CNPJ = '78767865000156';
        $this->nfe->tagdest($std);

        $std = new \stdClass();
        $std->xLgr = "rua jose bonifacio";
        $std->nro = '112';
        $std->xBairro = 'Boa Vista';
        $std->cMun = '3548807';
        $std->xMun = 'Sao caetano do sul';
        $std->UF = 'SP';
        $std->CEP = '09572050';
        $std->cPais = '1058';
        $std->xPais = 'BRASIL';
        $this->nfe->tagenderDest($std);
    }

    private function createProd(){
        $std = new \stdClass();
        $std->item = 1;
        $std->cProd = '0001';
        $std->xProd = "Produto teste";
        $std->NCM = '66554433';
        $std->CFOP = '5102';
        $std->uCom = 'PÇ';
        $std->qCom = '1.0000';
        $std->vUnCom = '10.99';
        $std->vProd = '10.99';
        $std->uTrib = 'PÇ';
        $std->qTrib = '1.0000';
        $std->vUnTrib = '10.99';
        $std->indTot = 1;
        $this->nfe->tagprod($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->vTotTrib = 10.99;
        $this->nfe->tagimposto($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->orig = 0;
        $std->CST = '00';
        $std->modBC = 0;
        $std->vBC = 0.20;
        $std->pICMS = '18.0000';
        $std->vICMS = '0.04';
        $this->nfe->tagICMS($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->cEnq = '999';
        $std->CST = '50';
        $std->vIPI = 0;
        $std->vBC = 0;
        $std->pIPI = 0;
        $this->nfe->tagIPI($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->CST = '07';
        $std->vBC = 0;
        $std->pPIS = 0;
        $std->vPIS = 0;
        $this->nfe->tagPIS($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->vCOFINS = 0;
        $std->vBC = 0;
        $std->pCOFINS = 0;
        $this->nfe->tagCOFINSST($std);
    }

    private function createTotal(){
        $std = new \stdClass();
        $std->vBC = 0.20;
        $std->vICMS = 0.04;
        $std->vICMSDeson = 0.00;
        $std->vBCST = 0.00;
        $std->vST = 0.00;
        $std->vProd = 10.99;
        $std->vFrete = 0.00;
        $std->vSeg = 0.00;
        $std->vDesc = 0.00;
        $std->vII = 0.00;
        $std->vIPI = 0.00;
        $std->vPIS = 0.00;
        $std->vCOFINS = 0.00;
        $std->vOutro = 0.00;
        $std->vNF = 11.03;
        $std->vTotTrib = 0.00;
        $this->nfe->tagICMSTot($std);
    }

    private function createTransp(){
        $std = new \stdClass();
        $std->modFrete = 1;
        $this->nfe->tagtransp($std);

        $std = new \stdClass();
        $std->item = 1;
        $std->qVol = 2;
        $std->esp = 'caixa';
        $std->marca = 'OLX';
        $std->nVol = '11111';
        $std->pesoL = 10.00;
        $std->pesoB = 11.00;
        $this->nfe->tagvol($std);
    }
    private function createFatura(){
        $std = new \stdClass();
        $std->nFat = '100';
        $std->vOrig = 100;
        $std->vLiq = 100;
        $this->nfe->tagfat($std);

        $std = new \stdClass();
        $std->nDup = '100';
        $std->dVenc = '2017-08-22';
        $std->vDup = 11.03;
        $this->nfe->tagdup($std);
    }
    public function getConfig()
    {
        $config = [
            "atualizacao" => "2018-02-06 06:01:21",
            "tpAmb" => 2, // Se deixar o tpAmb como 2 você emitirá a nota em ambiente de homologação(teste) e as notas fiscais aqui não tem valor fiscal
            "razaosocial" => "ARCNET DESEMVOLVIMENTO DE SOFTWARE",
            "siglaUF" => "SP",
            "cnpj" => "09000003000108",
            "schemes" => "PL_008i2",
            "versao" => "3.10",
            "tokenIBPT" => "AAAAAAA"
        ];
        return json_encode($config);
    }


}
