<?php

namespace App\Transformers;

use League\Fractal\TransformerAbstract;
use App\Entities\Logs;

/**
 * Class LogsTransformer.
 *
 * @package namespace App\Transformers;
 */
class LogsTransformer extends TransformerAbstract
{
    /**
     * Transform the Logs entity.
     *
     * @param \App\Entities\Logs $model
     *
     * @return array
     */
    public function transform(Logs $model)
    {
        return [
            'id'         => (int) $model->id,

            /* place your other model properties here */

            'created_at' => $model->created_at,
            'updated_at' => $model->updated_at
        ];
    }
}
