<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxDespesasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Despesas')) {
            Schema::create('cx_Despesas', function (Blueprint $table) {
                $table->integer('idDespesa', false, true);
                $table->integer('idAbertura', false, true);
                $table->string('stDescricao', 30);
                $table->dateTime('dtData');
                $table->decimal('vrDespesa', 9, 2);
                $table->integer('idFormaPagamento');
                $table->boolean('flCompensado');
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Despesas');
    }
}
