<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxGerenciadorTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Gerenciador')) {
            Schema::create('cx_Gerenciador', function (Blueprint $table) {

                $table->integer('idAbertura', false, true);
                $table->integer('idCaixa', false, true);
                $table->integer('idOperador', false, true);
                $table->dateTime('dtAbertura')->default(Carbon::now());
                $table->dateTime('dtFechamento')->nullable(true);
                $table->decimal('vrAbertura', 9, 2)->default(0);
                $table->decimal('vrFechamento', 9, 2)->default(0);
                $table->boolean('flAberto')->default(true);
                $table->decimal('vrTrocoEncerramento', 9, 2)->default(0);
                $table->boolean('flConferencia')->default(false);
                $table->integer('nrClientes', false, true)->default(0);
                $table->integer('idOrigem', false, true)->default(1);
                $table->integer('idDestino', false, true)->default(2);
                $table->string('stObs', 500)->nullable(true);
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary('idAbertura');

                // $table->foreign('idOperador')->references('idOperador')->on('op_Operadores');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Gerenciador');
    }
}
