<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstKardexHistoricoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_KardexHistorico')) {
            Schema::create('est_KardexHistorico', function (Blueprint $table) {
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->integer('idItem', false, true);
                $table->integer('idProduto', false, true);
                $table->dateTime('dtMovimentacao');
                $table->decimal('nrSaldoAnterior', 11, 3);
                $table->decimal('nrQuantidadeEntrada', 11, 3);
                $table->decimal('nrQuantidadeSaida', 11, 3);
                $table->decimal('nrSaldoAtual', 11, 3);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_KardexHistorico');
    }
}
