<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V624 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->alterCxFichaRecebimentoTemp();
        $this->alterCxFichaRecebimento();
        $this->alterDlvItens();
        $this->alterDlvAtendimentos();
        $this->alterMaster();
        $this->createPrinterPanelTable();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('monitorPreparo');
    }

    public function alterDlvAtendimentos()
    {
        if (Schema::hasTable('dlv_Atendimentos')) {
            if (!Schema::hasColumn('dlv_Atendimentos', 'reference')) {
                Schema::table('dlv_Atendimentos', function (Blueprint $table) {
                    $table->string('reference', 36)->nullable();
                    $table->string('cliente', 120)->nullable();
                    $table->string('stCpf', 16)->nullable();
                    $table->string('engine', 50)->nullable();

                    $table->string('fiscalStatus', 20)->nullable();
                    $table->string('fiscalProtocolo', 40)->nullable();
                    $table->string('chaveFiscal', 47)->nullable();
                    $table->decimal('desconto', 18, 2)->default(0);
                });
            }
        }
    }

    public function alterCxFichaRecebimentoTemp()
    {
        if (Schema::hasTable('cx_FichaRecebimentos_Temp')) {
            if (Schema::hasColumn('cx_FichaRecebimentos_Temp', 'autorizacao')) {
                Schema::table('cx_FichaRecebimentos_Temp', function (Blueprint $table) {
                    $table->string('autorizacao', 40)->change();
                });
            }
        }
    }

    public function alterCxFichaRecebimento()
    {
        if (Schema::hasTable('cx_FichaRecebimentos')) {
            if (Schema::hasColumn('cx_FichaRecebimentos', 'autorizacao')) {
                Schema::table('cx_FichaRecebimentos', function (Blueprint $table) {
                    $table->string('autorizacao', 40)->change();
                });
            }
        }
    }

    public function alterDlvItens()
    {
        if (Schema::hasTable('dlv_Itens')) {
            if (!Schema::hasColumns('dlv_Itens', ['codigo',
                'descricao',
                'cfop',
                'ncm',
                'cstIcms',
                'aliquotaIcms',
                'cstPis',
                'aliquotaPis',
                'cstCofins',
                'aliquotaCofins',
                'ibpt',
                'medida',
                'desconto'])) {

                Schema::table('dlv_Itens', function (Blueprint $table) {
                    $table->string('codigo', 14)->nullable();
                    $table->string('descricao', 29)->nullable();
                    $table->string('cfop', 4)->nullable();
                    $table->string('ncm', 8)->nullable();
                    $table->string('cstIcms', 3)->nullable();
                    $table->decimal('aliquotaIcms', 4, 2)->nullable();
                    $table->string('cstPis', 2)->nullable();
                    $table->decimal('aliquotaPis', 4, 2)->nullable();
                    $table->string('cstCofins', 2)->nullable();
                    $table->decimal('aliquotaCofins', 4, 2)->nullable();
                    $table->decimal('ibpt', 9, 2)->nullable();
                    $table->string('medida', 6)->nullable();
                    $table->decimal('desconto', 18, 2)->default(0);
                });
            }

        }
    }

    public function alterMaster()
    {
        if (Schema::hasTable('Master')) {
            if (!Schema::hasColumn('MASTER', 'flFiscalManager')) {
                Schema::table('Master', function (Blueprint $table) {
                    $table->boolean('flFiscalManager')->default(0);
                });
            }
        }
    }

//    public function createOrderCollection()
//    {
//        Schema::create('order', function($collection){
//            $collection->index('reference');
//        });
//    }

    public function createPrinterPanelTable()
    {
        if (!Schema::hasTable('monitorPreparo')) {
            Schema::create('monitorPreparo', function (Blueprint $table) {
                $table->uuid('id');
                $table->integer('idPrint', false, true);
                $table->json('payload');
                $table->boolean('concluded')->default(false);

                $table->timestamps();
            });
        }
    }


}
