<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterPrdProdutosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(Schema::hasTable('prd_Produtos')){
            if(!Schema::hasColumn('prd_Produtos', 'dtRevisaoTributaria')){
                Schema::table('prd_Produtos', function (Blueprint $table){
                    $table->dateTime('dtRevisaoTributaria')->nullable();
                });
            }
            if(!Schema::hasColumn('prd_Produtos', 'stOperadorRevisaoTributaria')){
                Schema::table('prd_Produtos', function (Blueprint $table){
                    $table->string('stOperadorRevisaoTributaria', 50)->nullable();
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasTable('prd_Produtos')){
            if(!Schema::hasColumn('prd_Produtos', 'dtRevisaoTributaria')){
                Schema::table('prd_Produtos', function (Blueprint $table){
                    $table->dropColumn('dtRevisaoTributaria');
                });
            }

            if(!Schema::hasColumn('prd_Produtos', 'stOperadorRevisaoTributaria')){
                Schema::table('prd_Produtos', function (Blueprint $table){
                    $table->dropColumn('stOperadorRevisaoTributaria');
                });
            }
        }
    }
}
