<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterDlvItens extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(Schema::hasColumn('dlv_itens', 'desconto')) {
            Schema::table('dlv_itens', function (Blueprint $table) {
                DB::statement($this->deleteConstraintDesconto());
                $table->decimal('desconto', 18,2)->nullable()->default(0)->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    public function deleteConstraintDesconto()
    {
        return "DECLARE @MyCursor CURSOR;
                DECLARE @FieldName varchar(200);
                DECLARE @tableName varchar(200) = 'dlv_Itens';
                DECLARE @Column varchar(200) = 'desconto';
                DECLARE @ShortColumn varchar(200) = 'desco';
                DECLARE @Cols AS int = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = @tableName AND COLUMN_NAME = @Column AND TABLE_SCHEMA='DBO')

                IF @Cols > 0
                BEGIN
                    SET @MyCursor = CURSOR FOR
                        SELECT name from sys.default_constraints where parent_object_id =OBJECT_ID(@tableName) AND name like '%' + @ShortColumn + '%'
                    OPEN @MyCursor
                    FETCH NEXT FROM @MyCursor
                    INTO @FieldName
                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                    EXEC('ALTER TABLE ['+ @tableName +'] drop constraint [' + @FieldName + ']')
                        FETCH NEXT FROM @MyCursor
                        INTO @FieldName
                    END
                    --EXEC('ALTER TABLE ['+ @tableName +'] drop column [' + @Column + ']')
                END";
    }
}
