<?php
/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */
class Paginacao extends Conexao {
    private $_table_name;
    private $_pagina =  1;
    private $_qnt_result_pagina = 10;//quantidade de resultado por pagina/paginacao
    private $_qnt_result = 0;//quantidade de resultados que sero ignorados na subquery
    private $_msg;
    private $_SQL;
    public $_SUBSQL;
    private $_primary_key;
    private $_campos;
    private $_SELECT;
    private $_INNER_JOIN;
    private $_WHERE;
    private $_ARGS;
    private $_ORDER;
    private $_GROUP;
    
    
    public function getMessage() {
        return $this->_msg;
    }
    
    /**
     * @param string $nm Nome da tabela que ir fazer a paginao
     * @return self Retorna o proprio objeto paginao 
     */
    public function setTableName($nm){
        $this->_table_name = $nm;
    // return $this;
    }
    
    public function setPagina($num = 1){
        $this->_pagina = (int) $num;
    //return $this;
    }
    
    public function setQntResultPagina($num = 10){
        $this->_qnt_result_pagina = (int) $num;
    //return $this;
    }
    
    /**
     * @param string $campos Adicionar os campos que devem ser buscados no SELECT. Caso nao seja adicionado nenhum argumento, buscar todos os campos da tabela especificada.
     * @return obj Retorna o objeto paginacao.
     */
    public function select($campos = "*"){
        $this->_qnt_result = ((($this->_qnt_result_pagina * $this->_pagina) - $this->_qnt_result_pagina) == 0 ? $this->_qnt_result_pagina : (($this->_qnt_result_pagina * $this->_pagina) - $this->_qnt_result_pagina));
        $this->_campos = $campos;
        $this->_SELECT = "SELECT TOP(".$this->_qnt_result_pagina.") ".$this->_campos." FROM ".$this->_table_name." ";
    //return $this;
    }
    
    /**
     * @param string $inner Fazer INNER JOIN em SELECT. Voc tem que adicionar com a clausula de comparao ON ou USING Pode adicionar varios
     */
    public function innerJoin($inner){
        $this->_INNER_JOIN .= " INNER JOIN ". $inner;
    //return $this;
    }
    
    public function setPrimaryKey($id){
        $this->_primary_key = $id;
    //return $this;
    }
    
    /**
     * @param string $args Passar como parametros os arquimentos que um SELECT pode receber: WHERE, AND, OR. Coloque GROUP e ORDER BY pelos metodos da classe.
     * @return obj retorna o objeto paginacao
     */
    public function setArgs($args){
        $this->_ARGS = $args;
    //return $this;
    }
    
    /**
     * @param strinbg $where Adicionar clausula WHERE ao SELECT. Pode ser adicionado apenas 1
     * @return obj Retorna o objeto paginacao;
     */
    public function onde($where){
        $this->_WHERE = " WHERE ".$where." ";
    //return $this;
    }
    
    /**
     * @param string $and Adiciona a clausula AND ao SELECT entre parenteses. Pode-se adicionar varias.
     * @return obj Retorna o objeto paginacao
     */
    public function e($and){
        $this->_ARGS .= " AND (".$and.") ";
    //return $this;
    }
    
    /**
     * @param string $or Adiciona a clausula OR ao SELECT entre parenteses. Pode-se adicionar varias.
     * @return obj Retorna o objeto paginao.
     */
    public function ou($or){
        $this->_ARGS .= " OR (".$or.") ";
    //return $this;
    }
    
    /**
     * @param string $group Adiciona a clausula GROUP BY ao SELECT com parenteses. Pode adicionar apenas 1
     * @return obj Retorna o objeto paginacao
     * */
    public function agrupandar($group){
        $this->_GROUP = " GROUP BY ".$group;
    //return $this;
    }
    
    /**
     * @param string $order Adiciona a clausula ORDER BY  ao SELECT. Pode-se adicionar paenas 1
     * @return obj Retorna o objeto paginacao
     */
    public function ordernar($order){
        $this->_ORDER = " ORDER BY ".$order;
    //return $this;
    }
    
    /**
     * @return boolean Retorna Booleano caso tenha executado a query com sucesso e false caso nao tenha conseguido..
     */
    public function executar(){
        if(self::validacao()) :
            $this->_SQL = $this->_SELECT . $this->_INNER_JOIN . $this->_WHERE . $this->_ARGS;
            if(empty($this->_WHERE) && empty($this->_ARGS)) :
                $this->_SQL .= " WHERE ".$this->_primary_key." NOT IN ";
            else :
                $this->_SQL .= " AND ".$this->_primary_key." NOT IN ";
            endif;
            $this->_SQL .= "(SELECT TOP(".($this->_qnt_result == $this->_qnt_result_pagina ? 0 : $this->_qnt_result).") ".$this->_primary_key." FROM ".$this->_table_name . $this->_INNER_JOIN . $this->_WHERE . $this->_ARGS . $this->_GROUP . $this->_ORDER.")";
            $this->_SQL .= $this->_GROUP . $this->_ORDER;
            
            $this->_SUBSQL = "SELECT ".$this->_campos." FROM ".$this->_table_name . $this->_INNER_JOIN . $this->_WHERE . $this->_ARGS . $this->_GROUP . $this->_ORDER;
            
            try{
                return parent::executar($this->_SQL);
            }catch(Exception $ex){
                $this->_msg = parent::getMessage() . $ex->getMessage();
                return false;
            }
        else :
            return false;
        endif;
    }
    
    private function validacao(){
        if(empty($this->_table_name)){
            $this->_msg = "O Nome da Tabela do SELECT para a paginao precisa ser expecificada no metodo setTableName";
        return false;
        }else if(empty($this->_SELECT)){
            $this->_msg = "Precisa especificar os campos que sero buscados para a paginao com o metodo select";
        return false;
        }else if(is_null($this->_primary_key)){
            $this->_msg = "Precisa especificar o campo PRIMARY KEY da tabela especificada no metodo setPrimary?Key";
            return false;
        }else if(empty($this->_WHERE) && (!empty($this->_ARGS) && strtoupper(substr($this->_ARGS, 0, 5)) != "WHERE")){
            $this->_msg = "Precisa especificar a clausula WHERE ou no metodo onde ou no metodo setArgs";
            return false;
        }else{
            return true;
        }
    }
    
    public function getQntPaginas(){
        return ceil((mssql_num_rows(parent::executar($this->_SUBSQL)) / $this->_qnt_result_pagina));
    }
    
    
    public function getHTMLPaginacao(){
        $qntTotalPaginas = self::getQntPaginas();
        $objHTMLPaginacao = '<div class="paginacao">';
        if($this->_pagina > 5) ://verificando se a pagina selecionada  maior que as 5 primeiras
            $objHTMLPaginacao .= '<span class="primeira"><a href="1">Primeira</a></span>';            
        endif;
        $objHTMLPaginacao .= '<ul>';
        
        //adicionando os nmeros as pginas
        if($this->_pagina <= 5) ://se for maior que as 5 paginas iniciais
            for($i = 1; $i <= 10; $i ++) :
                if($i > $qntTotalPaginas)
                    break;
                
                if($this->_pagina == $i) :
                    $objHTMLPaginacao .= '<li><span class="ativo">'.$i.'</span></li>';
                else :
                    $objHTMLPaginacao .= '<li><a href="'.$i.'">'.$i.'</a></li>';
                endif;
            endfor;
        else :
            for($i = ($this->_pagina - 5); $i <= ($this->_pagina + 5); $i++) :
                if($i > $qntTotalPaginas)
                    break;
                
                if($this->_pagina == $i) :
                    $objHTMLPaginacao .= '<li><span class="ativo">'.$i.'</span></li>';
                else :
                    $objHTMLPaginacao .= '<li><a href="'.$i.'">'.$i.'</a></li>';
                endif;
            endfor;
        endif;
        
        
        $objHTMLPaginacao .= '</ul>';
        $rst = ($qntTotalPaginas - $this->_pagina);//verificando se a pagina selecionada  menor que as 5 ultimas
        if($rst > 5) :
            $objHTMLPaginacao .= '<span class="ultima"><a href="'.$qntTotalPaginas.'">ltima</a></span>';
        endif;
        $objHTMLPaginacao .= '</div>';
    return $objHTMLPaginacao;
    }
    
}