$(document).ready(function () {
    var pagina = $("#idPagina").val();
    if(pagina == "localizacoes") {
        var data = {action: 'getLocais'};
        $.post('produtos/resources/php/geral_functions.php', data, function(dados) {
            var linha = '';
            for (var i = 0; i < dados.length; i++) {
                linha += '<tr><td class="tdStyle" id="st'+dados[i].idLocalizacao+'">'+dados[i].stLocalizacao+'</td>';
                linha += '<td class="tdStyle">';
                linha += '<a onclick="editLocal('+dados[i].idLocalizacao+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a onclick="excluirLocal('+dados[i].idLocalizacao+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
            }
            $(linha).appendTo($("#bodyTabelaCategoriasItens"));
        });
    }
    else if(pagina == "setores") {
        var data = {action: 'getSetores'};
        $.post('produtos/resources/php/geral_functions.php', data, function(dados) {
            var linha = '';
            for (var i = 0; i < dados.length; i++) {
                var reservas = '';
                if (dados[i].stReservaCodigosInicio && dados[i].stReservaCodigosFim) {
                    reservas = dados[i].stReservaCodigosInicio+' ~ '+dados[i].stReservaCodigosFim;
                }
                linha += '<tr><td class="tdStyle" id="st'+dados[i].idSetor+'">'+dados[i].stSetor+'</td>';
                linha += '<td class="tdStyle">'+dados[i].nrProdutos+'</td>';
                linha += '<td class="tdStyle">';
                linha += '<a onclick="editSetor('+dados[i].idSetor+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a onclick="excluirSetor('+dados[i].idSetor+')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
            }
            $(linha).appendTo($("#bodyTabelaCategoriasItens"));
            initializeDataTables("listagem_setores");
        });
    }
    else if(pagina == 'alterarPreco') {
        $('#table_precos').tablesorter();
        var data = {action: 'getCategorias'};
        $.post('produtos/resources/php/categorias_functions.php', data, function(response) {
            console.log(response)
            $('#selectCategoria').append($("<option></option>").attr("value", 0).text('Selecione uma Categoria'));
            for (var i = 0; i < response.length; i++) {
                $('#selectCategoria').append($("<option></option>").attr("value", response[i].idCategoria).text(response[i].stCategoria));
            }
        });
    }

    $('#percentage').mask('999');

});

function novoLocal () {
    $("#modalLocalTitle").html('Cadastro de Local');
    $("#modalLocal").modal('show');
}

function editLocal (idLocal) {
    var stLocal = $("#st"+idLocal).html();
    $("#codigoLocal").val(idLocal);
    $("#stLocal").val(stLocal);
    $("#modalLocalTitle").html('Edição de Local');
    $("#modalLocal").modal('show');
}

function cadastrarLocal() {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    var idLocal = $("#codigoLocal").val();
    var stLocal = $("#stLocal").val();
    if (stLocal.length == 0) {
        toastr.error('Digite um nome para a localização!');
        $("#divStLocal").addClass('has-error');
        return false;
    }
    var action = 'cadastrarLocal';
    if(idLocal) {
        action = 'editarLocal';
        var data = {action: action, idLocal: idLocal, stLocal: stLocal};
    } else {
        var data = {action: action, stLocal: stLocal};
    }
    $.post('produtos/resources/php/geral_functions.php', data, function(dados) {
        if(dados.status) {
            toastr.success(dados.msg);
            setTimeout(function(){location.reload();},1000);
        } else {
            toastr.error(dados.msg);
        }
    });
}

function excluirLocal(idLocal) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
        title: 'Tem certeza?',
        text: 'Tem certeza que deseja excluir esta Localização?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function() {
        $("body").addClass("loading");
        var data = {action: "excluirLocal", idLocal: idLocal};
        $.post('produtos/resources/php/geral_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status) {
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            } else {
                toastr.error(response.msg);
            }
        });
    });
}

$('#modalLocal').on('hidden.bs.modal', function (e) {
    $("#divStLocal").removeClass('has-error');
    $("#stLocal").val('');
});

function initializeDataTables(name) {
    $('#'+name).DataTable( {
        "language":
            {
                "url": "produtos/resources/js/Portuguese-Brasil.json"
            }
    });
}

//Setor
function novoSetor () {
    var data = {action: 'getReserva'};
    // $.post('produtos/resources/php/geral_functions.php', data, function (response) {
    //     for (var i = 0; i < response.length; i++) {
    //         $('#selectInicio').append($("<option></option>").attr("value", response[i]).text(response[i]));
    //         $('#selectFim').append($("<option></option>").attr("value", response[i]).text(response[i]));
    //     }
    // });
    $("#divSelectInicio").removeAttr('hidden');
    $("#divSelectFim").removeAttr('hidden');
    $("#modalSetorTitle").html('Cadastro de Setor');
    $("#modalSetor").modal('show');
}

function cadastrarSetor() {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    var idSetor = $("#codigoSetor").val();
    var stSetor = $("#stSetor").val();
    if (stSetor.length == 0) {
        toastr.error('Digite um nome para o Setor!');
        $("#divStSetor").addClass('has-error');
        return false;
    }
    var action = 'cadastrarSetor';
    if(idSetor) {
        action = 'editarSetor';
        var data = {action: action, idSetor: idSetor, stSetor: stSetor};
    } else {
        var selectInicio = $("#selectInicio").val();
        var selectFim = $("#selectFim").val();
        if (selectInicio > selectFim) {
            toastr.error('O valor de inicio não pode ser maior que o valor final!');
            $("#divSelectInicio").addClass('has-error');
            $("#divSelectFim").addClass('has-error');
            return false;
        }
        var data = {action: action, stSetor: stSetor, nrInicio: selectInicio, nrFim: selectFim};
    }
    $.post('produtos/resources/php/geral_functions.php', data, function(dados) {
        if(dados.status) {
            toastr.success(dados.msg);
            setTimeout(function(){location.reload();},1000);
        } else {
            toastr.error(dados.msg);
        }
    });
}

function excluirSetor(idSetor) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
        title: 'Tem certeza?',
        text: 'Tem certeza que deseja excluir este Setor?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function() {
        $("body").addClass("loading");
        var data = {action: "excluirSetor", idSetor: idSetor};
        $.post('produtos/resources/php/geral_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if(response.status) {
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            } else {
                toastr.error(response.msg);
            }
        });
    });
}

function editSetor (idSetor) {
    var stSetor = $("#st"+idSetor).html();
    $("#codigoSetor").val(idSetor);
    $("#stSetor").val(stSetor);
    $("#divSelectInicio").attr('hidden', 'hidden');
    $("#divSelectFim").attr('hidden', 'hidden');
    $("#modalSetorTitle").html('Edição de Setor');
    $("#modalSetor").modal('show');
}
$('#modalSetor').on('hidden.bs.modal', function (e) {
    $("#divSelectInicio").removeAttr('hidden');
    $("#divSelectFim").removeAttr('hidden');
    $("#divStSetor").removeClass('has-error');
    $("#divSelectInicio").removeClass('has-error');
    $("#divSelectFim").removeClass('has-error');
    $("#stSetor").val('');
});

function selectCategoria() {
    if ($('#selectCategoria').val() == 0) {
        return false;
    }
    $("#bodyPrecoCategoria").html('');
    var data = {action: 'getProdutosByCategoria', idCategoria: $('#selectCategoria').val()};
    $.post('produtos/resources/php/categorias_functions.php', data, function(response) {
        if (response) {
            console.log(response);
            linha = '';
            for (var i = 0; i < response.length; i++) {
                linha += "<tr id='id"+ response[i].idProduto +"' value='0'>";
                linha += "<td>"+ response[i].idCodigo +"</td>";
                linha += "<td>"+ response[i].stProduto +"</td>";
                linha += "<td><div class='input-group'>";
                linha += "<input id='custo"+response[i].idProduto+"' class='form-control smaller-inputs' align='right' value='"+parseFloat(response[i].vrCusto).toFixed(2)+"' onkeyup='changed("+ response[i].idProduto +")'>";
                linha += "<span class='input-group-btn'>";
                linha += "<button type='button' class='btn btn-new-nati smaller-inputs' onclick='calcularCusto("+response[i].idProduto+")'>C</button></span></div></td>";
                linha += "<td><div class='input-group'>";
                linha += "<input id='margem"+response[i].idProduto+"' class='form-control smaller-inputs' align='right' value='"+parseFloat(response[i].vrMargemLucro).toFixed(2)+"' onkeyup='changed("+ response[i].idProduto +")'>";
                linha += "<span class='input-group-btn'>";
                linha += "<button type='button' class='btn btn-new-nati smaller-inputs' onclick='calcularMargem("+response[i].idProduto+")'>M</button></span></div></td>";
                linha += "<td><div class='input-group'>";
                linha += "<input id='venda"+response[i].idProduto+"' class='form-control smaller-inputs' align='right' value='"+parseFloat(response[i].vrUnitario).toFixed(2)+"' onkeyup='changed("+ response[i].idProduto +")'>";
                linha += "<span class='input-group-btn'>";
                linha += "<button type='button' class='btn btn-new-nati smaller-inputs' onclick='calcularPreco("+response[i].idProduto+")'>P</button></span></div></td></tr>";
            }
            $(linha).appendTo($("#bodyPrecoCategoria"));
            for (var i = 0; i < response.length; i++) {
                $("#custo"+response[i].idProduto).maskMoney({allowZero:true, thousands:',', decimal:'.', affixesStay: false});
                $("#margem"+response[i].idProduto).maskMoney({allowZero:true, thousands:',', decimal:'.', affixesStay: false});
                $("#venda"+response[i].idProduto).maskMoney({allowZero:true, thousands:',', decimal:'.', affixesStay: false});
            }
            $('#table_precos').trigger('update');
        }
    });
}

function changed(id) {
    $('#id'+id).val(1);
}

function alterarPrecos() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    if ($('#selectCategoria').val() == 0) {
        toastr.error('Selecione uma categoria');
        return false;
    }

    var produtos = [];
    var acs = $('#radioAC').is(':checked');
    var dcs = $('#radioDC').is(':checked');
    if (acs || dcs) {
        swal({
            title: 'Alteração de preço',
            text: 'Esa ação irá alterar o valor de TODOS os produtos desta categoria, tem certeza que deseja continuar?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#2A98D3',
            cancelButtonColor: '#FF2727',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                swal.closeModal();
                var perc = $('#percentage').val();
                var id = '';
                $('#bodyPrecoCategoria > tr').each(function() {
                    id = $(this).attr('id').replace(/[^0-9\.]+/g, "");
                    if (acs == 1) {
                        var initV = parseFloat($('#venda'+id).val());
                        $('#venda'+id).val((initV + (initV / 100) * parseFloat(perc)));
                    } else {
                        var initV = $('#venda'+id).val();
                        $('#venda'+id).val((initV - (initV / 100) * parseFloat(perc)));
                    }
                    calcularMargem(id);
                    calcularPreco(id);
                    var values = $(this).children('td').children('div').children('input');
                    var item = {id: $(this).attr('id').replace(/[^0-9\.]+/g, ""), custo: values[0].value, margem: values[1].value, venda: values[2].value};
                    produtos.push(item);
                });
                var data = {action: 'updatePrecos', itens: produtos};
                $.post('produtos/resources/php/categorias_functions.php', data, function(response) {
                    if(response.status) {
                        toastr.success(response.msg);
                        setTimeout(function(){location.reload();},1000);
                    } else {
                        toastr.error(response.msg);
                    }
                });
            } else {
                $('#radioAC').removeAttr('checked');
                $('#radioDC').removeAttr('checked');
                swal('Cancelado', 'Valores de produtos não alterados', 'error');
            }
        });
    } else {
        $('#bodyPrecoCategoria > tr').each(function() {
            if ($(this).val() == '1') {
                var values = $(this).children('td').children('div').children('input');
                var item = {id: $(this).attr('id').replace(/[^0-9\.]+/g, ""), custo: values[0].value, margem: values[1].value, venda: values[2].value};
                produtos.push(item);
            }
        });
        var data = {action: 'updatePrecos', itens: produtos};
        $.post('produtos/resources/php/categorias_functions.php', data, function(response) {
            if(response.status) {
                toastr.success(response.msg);
                setTimeout(function(){location.reload();},1000);
            } else {
                toastr.error(response.msg);
            }
        });
    }
}

function calcularCusto(id) {
    var venda = parseFloat($('#venda'+id).val());
    var lucro = parseFloat($('#margem'+id).val());

    if ( (!venda == 0) || (!lucro == 0) ) {
        custo = (venda / (1 + lucro / 100)).toFixed(2);
        $("#custo" + id).val(custo);
    }else{
        $("#custo" + id).val(0)
    }
}

function calcularMargem(id) {
    var venda = parseFloat($('#venda'+id).val());
    var custo = parseFloat($('#custo'+id).val());

    if ( (!venda == 0) || (!custo == 0) ){
        lucro = (100 * venda / + custo - 100).toFixed(2);
        $("#margem"+id).val(lucro);
    }else{
        $("#margem"+id).val(0)
    }

}

function calcularPreco(id) {
    var lucro = parseFloat($('#margem'+id).val());
    var custo = parseFloat($('#custo'+id).val());

    if ( (!lucro== 0) || (!custo == 0) ){
        venda = (custo + custo * lucro / 100).toFixed(2);
        $("#venda"+id).val(venda);
    }else{
        $("#venda"+id).val(0)
    }


}
