<?php

namespace App\Console\Commands;

use App\Entities\Nati\OrderTab;
use App\Entities\Master;
use Carbon\Carbon;
use Illuminate\Console\Command;

class BloqueiaComanda extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bloqueia:comanda';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $masterConfigs = Master::first();

        if($masterConfigs['flBloquearComandasInativas']) {
            $comandas = OrderTab::where('flBloqueada', false)
                ->where('dtLastDate', '<=', Carbon::now()->subDays(5))
                ->get();

            foreach ($comandas as $comanda){
                $comanda->flBloqueada = true;
                $comanda->save();
            }
        }
    }
}
