<?php

namespace App\Entities;

use App\Entities\Nati\Product;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class CxItemsTemp extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Itens_Temp';
    protected $primaryKey = ['idItem', 'idVenda', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idItem',
        'idVenda',
        'idAbertura',
        'idProduto',
        'dtData',
        'nrQuantidade',
        'vrCusto',
        'vrUnitario',
        'vrDesconto',
        'flAtivo',
        'idComanda',
        'idCodProduto',
        'vrTotal',
        'vrTotalCusto',
        'idOperadorAutorizador',
        'stAtendente',
        'flEstoqueBaixado',
        'flPromocao',
        'dtAlteracao',
        'produto'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flEstoqueBaixado' => 'boolean',
        'flPromocao' => 'boolean',
    ];

    public function venda(){
        return $this->belongsTo(SaleTemp::class, 'idVenda', 'idVenda')
            ->where('idAbertura', $this->idAbertura);
    }

    public function produto()
    {
        return $this->belongsTo(Product::class, 'idProduto', 'idProduto');
    }
}

