<?php

namespace App\Entities\Delivery;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class DlvConfig extends Model implements Transformable
{
    use TransformableTrait;
    protected $table = 'dlv_Config';
    protected $primaryKey = 'idDelivery';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idDelivery',
        'stMarcaPrint',
        'stTipoPorta',
        'nrDddPadrao',
        'stRodapeCupom',
        'stCabecalhoCupom1',
        'stCabecalhoCupom2',
        'stCabecalhoCupom3',
        'stCabecalhoCupom4',
        'stCidade',
        'stEstado',
        'nrVias',
        'idMicroterminal',
        'flTaxaEntregaUnica',
        'vrTaxaEntregaUnica',
        'nrAlertaEntrega',
        'flSolicitarOperador',
        'flAtivo',
        'flPrintCupomPreparo',
        'dtAlteracao',
        'flPrintManager',
        'flAssumirPedido',
        'flHorarios'
    ];

    protected $casts = [
        'flTaxaEntregaUnica' => 'boolean',
        'flSolicitarOperador' => 'boolean',
        'flAssumirPedido' => 'boolean',
        'flPrintCupomPreparo' => 'boolean',
        'flAtivo' => 'boolean',
        'flPrintManager' => 'boolean',
        'vrTaxaEntregaUnica' => 'float',
        'nrAlertaEntrega' => 'integer',
        ];
}
