<?php


namespace App\Entities\Delivery;


use Illuminate\Database\Eloquent\Model;

class SubItem extends Model
{
    protected $table = "dlv_subItens";
    protected $primaryKey = ['idAtendimento', 'nrItem', 'nrItem'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idAtendimento',
        'nrItem',
        'nrSubItem',
        'descricao',
        'quantidade',
        'vrUnitario',
        'vrTotal',
    ];

    public function item()
    {
        return $this->belongsTo(Item::class, ['idAtendimento', 'nrItem']);
    }
}
