<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use App\Entities\User;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class GerenciadorDetalhes extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'cx_GerenciadorDetalhes';
    protected $primaryKey = ['idAbertura', 'idFormaPagamento', 'idDetalhe'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idAbertura',
        'idFormaPagamento',
        'idDetalhe',
        'vrPagamento',
        'idOperador',
        'vrPagamentoMicro',
        'flPendente',
        'dtAlteracao',
        'formaPagamento',
        'operador'
    ];

    protected $casts = [
        'flPendente' => 'boolean',
    ];

    public function formaPagamento()
    {
        return $this->belongsTo(FormaPagamento::class, 'idFormaPagamento', 'idFormaPagamento');
    }

    public function operador()
    {
        return $this->belongsTo(User::class, 'idOperador', 'idOperador');
    }
}

