<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasCompositePrimaryKey;
use App\Entities\User;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Repique extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Repique';
    protected $primaryKey = ['idRepique', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idRepique',
        'idAbertura',
        'idOperador',
        'dtData',
        'vrRepique',
        'idFormaPagamento',
        'idOperadorAutorizador',
        'flTroco',
        'flAtivo',
        'dtAlteracao'
    ];

    protected $appends = [
//        'id',
//        'id_open',
//        'id_operator',
//        'date',
//        'value_repique',
//        'id_payment',
//        'id_operator_authorize',
//        'is_change',
//        'active',
//        'update_date',
    ];

    protected $hidden = [
//        'idRepique',
//        'idAbertura',
//        'idOperador',
//        'dtData',
//        'vrRepique',
//        'idFormaPagamento',
//        'idOperadorAutorizador',
//        'flTroco',
//        'flAtivo',
//        'dtAlteracao'
    ];

    protected $maps = [
//        'id' => 'idRepique',
//        'id_open' => 'idAbertura',
//        'id_operator' => 'idOperador',
//        'date' => 'dtData',
//        'value_repique' => 'vrRepique',
//        'id_payment' => 'idFormaPagamento',
//        'id_operator_authorize' => 'idOperadorAutorizador',
//        'is_change' => 'flTroco',
//        'active' => 'flAtivo',
//        'update_date' => 'dtAlteracao'
    ];

    protected $casts = [
        'flTroco' => 'boolean',
        'flAtivo' => 'boolean',
    ];

    public function operador()
    {
        return $this->hasOne(User::class, 'idOperador', 'idOperador');
    }

    public function abertura()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }
}
