<?php

namespace App\Http\Controllers;

use App\Entities\Logs;
use Exception;
use Illuminate\Http\Request;
use App\Services\Nati\BalanceProductsService;

class BalanceProductsController extends Controller
{
    protected $service;

    public function __construct(BalanceProductsService $service)
    {
        $this->service = $service;
    }

    public function getProductsBalance(Request $request)
    {
        if($request['filter'] == 'stProduto') {
            return $this->service->filterProducts($request);
        }
        return $this->service->getProductsBalance($request);
    }

    public function filterProducts(Request $request)
    {
        return $this->service->filterProducts($request);
    }

    public function getAllProductsBalance(Request $request)
    {
        $products = $this->service->getAllProductsBalance($request);
        return $products;
    }

    public function countProductsBalance()
    {
        $count = $this->service->countProductsBalance();
        return $count;
    }

    public function updateProductsBalance(Request $request)
    {
        try{
            $response = response()->json($this->service->updateProductsBalance($request->all()));
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PRODUTOS", 'O USUARIO [' . $user->stApelido . '] ALTEROU A LISTA DE PRODUTOS DE BALANÇA');
            return $response;
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function generateFiles(Request $request)
    {
        try{
            return response()->json($this->service->generateFiles($request->all()));
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function downloadFiles($file)
    {
        try{
            $response = $this->service->downloadFiles($file);
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "PRODUTOS", 'O USUARIO [' . $user->stApelido . '] GEROU UM ARQUIVO ITENS DE BALANÇA');
            return $response;
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
}
