<?php

namespace App\Http\Controllers;

use App\Entities\Nati\Cest;
use App\Entities\Nati\Product;

class CestsController
{
    public function show($ncm)
    {
        try {
            return Cest::findOrFail($ncm);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }

    }

    public function insertCESTsAllProducts()
    {
        $productsWithoutCest = Product::select('idProduto', 'nrNCM')
                                        ->whereRaw('LENGTH(stCest) <> 7')
                                        ->get();

        foreach ($productsWithoutCests as $item) {
            $cest = Cest::select('nrCest')
                            ->where('nrNCM', '=', $item['nrNCM'])
                            ->get();

            Product::where('idProduto', '=', $item['idProduto'])
                        ->update(['stCest' => $cest]);
        }
    }
}
