<?php

namespace App\Jobs;

use App\Entities\Comanda;
use App\Entities\SaleTemp;
use App\Services\Sales\SalesService;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class ProcessComanda implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $comanda;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($comanda)
    {
        $this->comanda = $comanda;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            DB::beginTransaction();
            $venda = SaleTemp::create([
                'idVenda' => $this->nextId(),
                'idAbertura' => "",
                'vrTotal' => $this->comanda['vrTotal'],
                'flNotaFiscal' => false,
                'dtData' => $this->comanda['dtData'],
                'idCliente' => "0",
                'vrDesconto' => "0",
                'vrAcrescimo' => "0",
                'flAtivo' => true,
                'nrTempoAtendimento' => "0",
                'idOperadorAutorizador' => "99",
                'stFraseCupom' => "Obrigado",
                'flDelivery' => false,
                'idAtendimentoDelivery' => "0",
                'stContaAssinada' => "0",
                'dtAlteracao' => $this->comanda['dtData'],
                'nrCOO' => "0",
                'stCPF' => "",
                'chave_fiscal' => "",
            ]);
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
        }
    }

    public function nextId()
    {
        return SaleTemp::max('idVenda') + 1;
    }
}
