<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\SatEquipamentoRepository;
use App\Entities\Nati\SatEquipamento;
use App\Validators\Nati\SatEquipamentoValidator;

/**
 * Class SatEquipamentoRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class SatEquipamentoRepositoryEloquent extends BaseRepository implements SatEquipamentoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return SatEquipamento::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return SatEquipamentoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
