<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 31/10/2017
 * Time: 15:59
 */

namespace App\Services\Nati;


use App\Entities\Nati\TabelaNutricional;
use App\Repositories\TabelaNutricionalRepository;
use App\Validators\TabelaNutricionalValidator;

class TabelaNutricionalService
{
    protected $repository;
    protected $validator;

    public function __construct(TabelaNutricionalRepository $repository, TabelaNutricionalValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->all();
    }

    public function getById($id)
    {
        return $this->repository->findWhere(['idProduto' => $id])->first();
    }

    public function upsert($data, $id = null)
    {
        $model = $this->getById($id);
        if (is_null($model)) {
            $data['idTabelaNutricional'] = TabelaNutricional::max('idTabelaNutricional') + 1;
            $data['idProduto'] = $id;
            $result = $this->repository->create($data);
        } else {
            $result = $this->repository->update($data, $model->idTabelaNutricional);
        }
        return $result;
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }
}