<?php

namespace App\Services;

use App\Entities\Nati\FormaPagamento;
use App\Repositories\Nati\PaymentMethodsRepository;
use App\Services\Service;
use App\Validators\Nati\PaymentMethodsValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

class PaymentMethodsService extends Service
{

    protected $repository;
    protected $validator;


    public function __construct(PaymentMethodsRepository $repository, PaymentMethodsValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->with('tipo')->findWhere(['flAtivo' => true]);
    }

    public function getById($id)
    {
        return $this->repository->find($id);
    }

    public function search($string)
    {
        return $this->repository->findWhere([['stFormaPagamento', 'LIKE', '%' . $string . '%']]);
    }

    public function create($data)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $data['id'] = $this->nextId();
        $data['updated_at'] = Carbon::now();
        $data['active'] = true;

        $response = $this->repository->create($data);

        return $response;
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        $data['active'] = true;
        $data['updated_at'] = Carbon::now();
        $data['parent_id'] = 0;

        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        $payment = $this->repository->find($id);

        if ($payment) {
            $payment->active = false;
            $payment->save();
            return $payment;
        }
        throw new BadRequestHttpException('Não é possivel excluir esta forma de pagamento');
    }

    private function nextId()
    {
        return FormaPagamento::max('idTipoForma') + 1;
    }

}
