<?php


namespace App\Services;


use App\Entities\Master;
use App\Entities\Company;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\GuzzleException;
use http\Env\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class PaymentProviderService
{
    private $iuguService;

    public function __construct(IuguService $iuguService)
    {
        $this->iuguService = $iuguService;
    }

    public function getCompany()
    {
        if(!$this->hasToken()) return;

        if($this->isFirstAccess()) return;

        $companyDb = Company::first();
        if(!$companyDb) {
            $companyProviderData = $this->getCompanyInProvider();
            $companyDb = $this->storeCompanyInDB($companyProviderData);
        }

        return $this->updateSubscription($companyDb);
    }

    private function hasToken()
    {
        $master = Master::first();
        if(empty($master['subAccountToken'])) return false;
        return true;
    }

    private function isFirstAccess()
    {
        $companyProviderData = $this->getCompanyInProvider();
        if(!$companyProviderData)
            return true;
        return false;
    }

    private function getCompanyInProvider()
    {
        $masterData = Master::first();
        $iuguCompanyData = $this->iuguService->getCompany($masterData['stCNPJ']);
        if(isset($iuguCompanyData['id']))
            return $iuguCompanyData;

        return;
    }

    private function updateSubscription($company)
    {
        $subscription = $this->getSubscriptions($company->paymentProviderClientId);
        if(isset($subscription['id']))
            $this->updateSubscriptionInDB($subscription);

        if(!isset($subscription['id']))
            $this->removeSubscriptionDB();

        return Company::first();
    }

    private function getSubscriptions($paymentProviderClientId)
    {
       $subscriptions = $this->iuguService->getSubscriptions($paymentProviderClientId);
       if($subscriptions) {
           $subscriptions = $this->searchIdentify($subscriptions);
       }

       $res = null;
       if(isset($subscriptions['id'])) $res = $this->subscriptionIsExists($subscriptions['id']);

       return $res;
    }

    private function searchIdentify($subscriptions)
    {
        //REFATORAR*
        foreach($subscriptions['items'] as $key => $val) {
            if(array_key_exists(0, $subscriptions['items'][$key]['custom_variables'])) {
                if(in_array('NATI', $subscriptions['items'][$key]['custom_variables'][0])) {
                    return $subscriptions['items'][$key];
                }
            }
        }

        foreach($subscriptions['items'] as $key => $val) {
            if(array_key_exists(0, $subscriptions['items'][$key]['custom_variables'])) {
                if(in_array('Nati', $subscriptions['items'][$key]['custom_variables'][0])) {
                    return $subscriptions['items'][$key];
                }
            }
        }

        foreach($subscriptions['items'] as $key => $val) {
            if(array_key_exists(0, $subscriptions['items'][$key]['custom_variables'])) {
                if(in_array('nati', $subscriptions['items'][$key]['custom_variables'][0])) {
                    return $subscriptions['items'][$key];
                }
            }
        }
    }

    public function storeCompany($request)
    {
        $this->validateCNPJ($request);
        $iuguCompanyData = $this->iuguService->getCompany($request->cnpj);

        if($iuguCompanyData) {
            return $this->storeCompanyInDB($iuguCompanyData);
        }

        $response = $this->iuguService->storeClient($request);

        if($response) $this->storeCompanyInDB($response);
        return $response;
    }

    private function updateSubscriptionInDB($subscription = null)
    {
        if($subscription) {
            $company = Company::first();
            $company->paymentProviderSubscriptionId = $subscription['id'];
            $company->suspended = $subscription['suspended'];
            $company->active = $subscription['active'];
            $company->save();
        } else {
            $this->removeSubscriptionDB();
        }
    }

    private function removeSubscriptionDB()
    {
        $company = Company::first();

//        if(!$company->paymentProviderSubscriptionId) {
//            return;
//        }

        $company->paymentProviderSubscriptionId = null;
        $company->suspended = false;
        $company->active = true;
        $company->save();

        return $company;
    }

    private function subscriptionIsExists($id = null)
    {
        try{
            $res = $this->searchSubscription($id);
            return $res;
        } catch (\Exception $e) {
            return null;
        }
    }

    private function storeCompanyInDB($data)
    {
        $company = new Company;
        $company->id = 1;
        $company->nome = $data['name'];
        $company->cnpj = $data['cpf_cnpj'];
        $company->email = $data['email'];
        $company->cep = $data['zip_code'];
        $company->rua = $data['street'];
        $company->numero = $data['number'];
        $company->complemento = $data['complement'];
        $company->bairro = $data['district'];
        $company->cidade = $data['city'];
        $company->estado = $data['state'];
        $company->telefone = $data['phone'];
        $company->prefixo = $data['phone_prefix'];
        $company->paymentProvider = 'IUGU';
        $company->paymentProviderClientId = $data['id'];
        $company->paymentProviderSubscriptionId = null;
        $company->suspended = false;
        $company->emails_cc = $data['cc_emails'];
        $company->save();

        return $company;
    }

    private function updateCompanyInDB($paymentProviderClientId, $request)
    {
        $company = Company::where('id', 1)
                ->update([
                    'nome' => $request->nome,
                    'cnpj' => $request->cnpj,
                    'email' => $request->email,
                    'cep' => $request->cep,
                    'rua' => $request->rua,
                    'numero' => $request->numero,
                    'complemento' => $request->complemento,
                    'bairro' => $request->bairro,
                    'cidade' => $request->cidade,
                    'estado' => $request->estado,
                    'telefone' => $request->telefone,
                    'prefixo' => $request->prefixo,
                    'paymentProvider' => 'IUGU',
                    'paymentProviderClientId' => $paymentProviderClientId,
                    'paymentProviderSubscriptionId' => null,
                    'suspended' => false,
//                    'emails_cc' => $request->cc_emails
                ]);
        return $company;
    }

    private function validateCNPJ($request)
    {
        $masterData = Master::first();
        if($request->cnpj != $masterData->stCNPJ) {
            throw new \Exception('CNPJ INVALIDO');
        }
        return;
    }

    public function searchSubscription($idSubscription)
    {
        return $this->iuguService->searchSubscription($idSubscription);
    }

    public function hasMigration()
    {
        if(!Schema::hasTable('company')) {
            return false;
        }

        if(!Schema::hasColumn('company', 'emails_cc')) {
            return false;
        }

        if(!Schema::hasColumn('master', 'subAccountToken')) {
            return false;
        }

        return true;
    }

    public function activateSubscription($id)
    {
        return $this->iuguService->activateSubscription($id);
    }

//    public function getInvoices()
//    {
//        $master = Master::first();
//
//        return $this->iuguService->getInvoices($master->cnpj);
//    }
}
