<?php


namespace App\Validators\Delivery;


use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\LaravelValidator;

class OrderValidator extends LaravelValidator
{
    protected $rules = [
        ValidatorInterface::RULE_CREATE => [
            'idAtendimento' => 'required',
            'idOperador' => 'required',
            'idCliente' => 'required',
            'items' => 'required|array|min:1',
            'items.*.nrItem' => 'required',
            'items.*.idAtendimento' => 'required',
            'items.*.idProduto' => 'required',
            'items.*.stOperador' => 'required',
            'items.*.nrQuantidade' => 'required|numeric',
            'items.*.dtData' => 'required|date',
            'items.*.vrUnitario' => 'required|numeric',
            'items.*.vrTotal' => 'required|numeric',
            'items.*.idComanda' => 'required',
            'items.*.flPrint' => 'required',
            'items.*.dtAlteracao' => 'required',
            'items.*.flAtivo' => 'required|boolean',

            'payments'=> 'required|array|min:1',
            'payments.*.idFicha'=> 'required',
            'payments.*.idAtendimento'=> 'required',
            'payments.*.dtData'=> 'required',
            'payments.*.flTroco'=> 'required',
        ],
        ValidatorInterface::RULE_UPDATE => [],
    ];

}
