<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxItensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Itens')) {
            Schema::create('cx_Itens', function (Blueprint $table) {
                $table->integer('idItem', false, true);
                $table->integer('idVenda', false, true);
                $table->integer('idAbertura', false, true);
                $table->integer('idProduto', false, true);
                $table->dateTime('dtData');
                $table->decimal('nrQuantidade', 10, 3);
                $table->decimal('vrCusto', 9, 2);
                $table->decimal('vrUnitario', 9, 2);
                $table->decimal('vrDesconto', 9, 2);
                $table->boolean('flAtivo')->default(true);
                $table->integer('idComanda');
                $table->decimal('idCodProduto', 13, 0);
                $table->decimal('vrTotal', 9, 2);
                $table->decimal('vrTotalCusto', 9, 2);
                $table->integer('idOperadorAutorizador');
                $table->string('stAtendente', 20)->nullable();
                $table->boolean('flEstoqueBaixado')->default(false);
                $table->boolean('flPromocao')->default(false);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Itens');
    }
}
