<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvMotoboyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Motoboy')) {
            Schema::create('dlv_Motoboy', function (Blueprint $table) {
                $table->smallInteger('idMotoboy');
                $table->string('stMotoBoy', 30);
                $table->decimal('vrComissao', 9, 2);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->primary('idMotoboy');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Motoboy');
    }
}
