<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdCategoriasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Categorias')) {
            Schema::create('prd_Categorias', function (Blueprint $table) {
                $table->integer('idCategoria', false, true);
                $table->string('stCategoria', 50);
                $table->float('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->string('stReservaCodigosInicio', 10)->nullable();
                $table->string('stReservaCodigosFim', 10)->nullable();
                $table->primary('idCategoria');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Categorias');
    }
}
