<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdTabelasNutricionaisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_TabelasNutricionais')) {
            Schema::create('prd_TabelasNutricionais', function (Blueprint $table) {
                $table->integer('idTabelaNutricional', false, true);
                $table->integer('idProduto', false, true);
                $table->decimal('nrQuantidade', 8, 3);
                $table->integer('nrUnidadePorcao', false, true);
                $table->integer('nrParteInteiraMedidaCaseira', false, true);
                $table->integer('nrParteDecimalMedidaCaseira', false, true);
                $table->integer('nrMedidaCaseira', false, true);
                $table->integer('nrValorEnergetico', false, true);
                $table->decimal('nrCarboidratos', 4, 1);
                $table->decimal('nrProteinas', 3, 1);
                $table->decimal('nrGordurasTotais', 3, 1);
                $table->decimal('nrGordurasSaturadas', 3, 1);
                $table->decimal('nrGordurasTrans', 3, 1);
                $table->decimal('nrFibraAlimentar', 3, 1);
                $table->decimal('nrSodio', 5, 1);
                $table->dateTime('dtAlteracao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_TabelasNutricionais');
    }
}
