<?php

class Util {
    
    public static function validaDigitoVerificador($comanda, $tipoComanda, $numeroDigitos){
        $value = preg_replace('/[^0-9]/', '', $comanda);
        if (strlen($value) < 2) {
            return false;
        }

        $numeral = substr($value, 0, strlen($value) - 1);
        $digit = substr($value, strlen($value) - 1);

        $sumValoeres = 0;
        $multiplicador = 2;

        switch ($tipoComanda) {
            case "WDDD":{
                return true;
            break;
            }
            case "WDDDVE":
                $multiplicador = 3;
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sumValoeres += intval($numeral[$i - 1]) * intval($multiplicador);
                    $multiplicador = ($multiplicador == 3 ? 1 : 3);
                }
                $sumValoeres = 10 - ($sumValoeres % 10);
                if ($sumValoeres == 10) $sumValoeres = 0;
                break;
            case "WDDDV11":
            {
                //comanda = numeral.ToString(new string('0', nrDiditos - 2));
                $multiplicador = 2;
                $sumValoeres = 0;
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sumValoeres += intval($numeral[$i - 1]) * intval($multiplicador);
                    $multiplicador++;
                }
                $sumValoeres = (intval($sumValoeres) * 10) % 11;

                if ($sumValoeres == 10) $sumValoeres = 0;
                return $sumValoeres == intval($digit);
            }
            default:
                for ($i = strlen($numeral); $i > 0; $i--) {
                    $sumValoeres += $numeral[$i - 1] * $multiplicador;
                    $multiplicador++;
                }
                $sumValoeres = (intval($sumValoeres) * 10) % 11;
                $sumValoeres += -2;

                if ($sumValoeres < 0) {
                    if ($sumValoeres == -1) $sumValoeres = 0;
                    if ($sumValoeres == -2) $sumValoeres = 9;
                }
                break;
        }
        if ($sumValoeres == $digit) {
            return true;
        }
        $comanda = "7" . str_pad($numeral, intval($numeroDigitos) - 2, '0', STR_PAD_LEFT);
        $multiplicador = 2;
        $sumValoeres = 0;

        for ($i = strlen($comanda); $i > 0; $i--) {
            $sumValoeres += intval($comanda[$i - 1]) * intval($multiplicador);
            $multiplicador++;
        }
        $sumValoeres = (intval($sumValoeres) * 10);
        $sumValoeres = intval($sumValoeres) % 11;
        //$sumValoeres += -2;
        if ($sumValoeres == 10) {
            $sumValoeres = 0;
        }
        return $sumValoeres == $digit;
    }

    public static function getNumeroComanda($comanda, $letra_comanda = "W", $tipoComanda ,$letra_digito = "V", $nrDigitosComanda){

        if($tipoComanda == "WDDDV") :
            return $n_comanda = substr($comanda,  1, stripos($nrDigitosComanda, $letra_digito) - 1);
        elseif($tipoComanda =="WDDD") :
            return $n_comanda = substr($comanda, stripos("WDDD", $letra_comanda) + 1);
        else :
            return false;
        endif;
    }
}
