document.addEventListener("DOMContentLoaded", function() {
	toastr.options = {"positionClass": "toast-bottom-right"};
	getCaixas();
	$('#modalVenda').on('hidden.bs.modal', function () {
		$("#bodyVenda").html('');
	});
	var date = new Date();
	var day = date.getDate();
	if (day < 10) {
		day = '0'+day;
	}
	var month = date.getMonth() + 1;
	if (month < 10) {
		month = '0'+month;
	}
	$('#de').val('01/'+month+'/'+date.getFullYear());
	$('#ate').val(day+'/'+month+'/'+date.getFullYear());
	$(".data").datepicker({
		format: 'dd/mm/yyyy',
		language: 'pt-BR',
		autoclose: true
	});
	$(".data").mask('99/99/9999');
});

function openModal() {
	$('#modalVenda').modal('show');
}

function getCaixas() {
	$('#caixa').append($('<option></option>').val('0').html('Todos'));
	$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', {action: 'getCaixas'}, function(response){
		for (var i = 0; i < response.length; i++) {
			$('#caixa').append($('<option></option>').text('Caixa ' + response[i]['idCaixa']).attr('value', response[i]['idCaixa']));
		}
	});
}

function avancar(){
	var data = {
		action: 'getVendasCaixas',
		de: $("#de").val(),
		ate: $("#ate").val(),
		caixa: $("#caixa").val()
	}
	$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', data, function(response){
		if (response) {
			var linha = '';
			for (var i = 0; i < response.length; i++) {
				$('#listaFechamentos').append($("<option></option>").text(response[i]['stApelido']+' (CAIXA: '+response[i]['idCaixa']+' - ABERTO: '+response[i]['dtAbertura']+') (FECHADO: '+response[i]['dtFechamento']+')').attr('value', response[i]['idAbertura']));
			}
			$('#divAberturas').removeAttr('hidden');
		}else{
			swal('Erro', 'Nenhum resultado foi encontrado!', 'error')
		}
	});
}

function gerarRelatorio() {
	var data = {
		action: 'gerarRelatorio',
		idAbertura: $("#listaFechamentos").val()
	}
	$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', data, function(response){
		if(response['vendas']){
			var linha = '';
			for (var i = 0; i < response['vendas'].length; i++) {
				var atual = response['vendas'][i];
				linha += '<tr>';
				linha += '<td>'+atual['idVenda']+'</td>';
				linha += '<td>'+atual['stCliente']+'</td>';
				linha += '<td>R$ '+atual['vrTotal']+'</td>';
				if (atual['flNotaFiscal'] == 1) {
					linha += '<td align="center">';
					linha += '<div class="btn-group" role="group">';
					linha += '<button type="button" class="btn btn-new-nati" onclick="getXML('+atual['idVenda']+', '+atual['idAbertura']+')" title="Download">';
					linha += '<span class="glyphicon glyphicon-download"></span>'
					linha += '</button>';
					linha += '<a id="link'+atual['idVenda']+'-'+atual['idAbertura']+'" href="#" download hidden><a>'
					linha += '<button type="button" class="btn btn-new-nati" onclick="visualizarXML('+atual['idVenda']+', '+atual['idAbertura']+')" title="Visualizar">';
					linha += '<span class="glyphicon glyphicon-search"></span>'
					linha += '</button>';
				}
				else{
					linha += '<td></td>';
				}
				linha += '</td>';
				linha += '</tr>';
			}
			var linha2 = '';
			var linha3 = '';
			var linha4 = '';
			if($("#caixa").val() == 0){
				linha2 += '<p align="center">Relatório de Vendas referente a Abertura nº'+$("#listaFechamentos").val()+'.</p>';
			}else{
				linha2 += '<p align="center">Relatório de Vendas do Caixa '+$("#caixa").val()+'.</p>';
				linha2 += '<p align="center">Relatório de Vendas referente a Abertura nº'+$("#listaFechamentos").val()+'.</p>';
			}
			linha3 += '<p align="center">Relatório referente ao mês de '+$("#de").val()+' á '+$("#ate").val()+'.</p>';
			linha4 += '<p align="center">Relatório emitido por '+response['op']['stApelido']+' em '+response['date']+' às '+response['time']+'.</p>';
		}
		$('#divPeriodo').attr('hidden', true);
		$('#divAberturas').attr('hidden', true);
		$('#relatorioCaixa').removeAttr('hidden');
		$(linha).appendTo($('#bodyRelatorio'));
		$(linha2).appendTo($('#titleRelatorio'));
		$(linha3).appendTo($('#mesRelatorio'));
		$(linha4).appendTo($('#dataHoraRelatorio'));
	});
}

function backFiltro() {
	$("#tabelas").empty();
	$('#divPeriodo').removeAttr('hidden');
	$('#divAberturas').removeAttr('hidden');
	$('#relatorioCaixa').attr('hidden', true);
}

function getXML(venda, abertura){
	$('body').addClass('loading');
	$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', {action: 'getXML', venda: venda, abertura: abertura}, function(response){
		$('body').removeClass('loading');
		if (response['status']) {
			$("body").append("<iframe src='relatorios/resources/php/"+response['msg']+"'style='display: none;'></iframe>");
			$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', {action: 'deleteFile'} );
		}
	});
    $('body').removeClass('loading');
}

function visualizarXML(venda, abertura){
	$.post('relatorios/resources/php/cuponsFiscaisEmitidos.php', {action: 'visualizarXML', venda: venda, abertura: abertura}, function(response){
		$('body').removeClass('loading');
		var xml = response['msg']['xml']['infCFe'];
		var linha = '';
		if (response['status']) {
			linha += '<tr><td colspan="3">'+xml['emit']['xFant']+'</td</tr>';
			linha += '<tr><td colspan="3">'+xml['emit']['xNome']+'</td></tr>';
			linha += '<tr><td colspan="3">'+xml['emit']['enderEmit']['xLgr']+' '+xml['emit']['enderEmit']['nro']+' '+xml['emit']['enderEmit']['xBairro']+'-'+xml['emit']['enderEmit']['xMun']+'/'+xml['emit']['enderEmit']['CEP']+'</td></tr>';
			linha += '<tr><td colspan="3">CNPJ: '+xml['emit']['CNPJ']+' IE: '+xml['emit']['IE']+' IM: </td></tr>';
			linha += '<tr><td colspan="3">--------------------------------------------------------</td></tr>';
			linha += '<tr><td colspan="3">Extrato No. '+xml['ide']['nCFe']+'</td></tr>';
			linha += '<tr><td colspan="3">CUPOM FISCAL ELETRONICO - SAT</td></tr>';
			linha += '<tr><td colspan="3">--------------------------------------------------------</td></tr>';
			linha += '<tr><td colspan="3">#|COD|DESC  |QTD |UN |VL UN R$|(VL TR R$)* |VL ITEM R$</td></tr>';
			linha += '<tr><td colspan="3">--------------------------------------------------------</td></tr>';
			if( Object.prototype.toString.call( xml['det'] ) === '[object Array]' ) {
				for (var i = 0; i < Object.keys(xml['det']).length; i++) {
					var prod = xml['det'][i];
					var qtd = prod['prod']['qCom'];
					qtd = qtd.match(/.{1,4}/g);
					linha += '<tr><td style="text-align: left" width="50%">0'+prod['@attributes']['nItem']+' '+prod['prod']['cProd']+' '+prod['prod']['xProd']+'</td><td width="1%"> </td><td style="text-align: right" width="49%">'+prod['prod']['vProd']+' X '+qtd['0']+' '+prod['prod']['uCom']+' '+prod['prod']['vItem']+'</td></tr>';
				}
			}else{
				var qtd = xml['det']['prod']['qCom'];
				qtd = qtd.match(/.{1,4}/g);
				var x = Object.keys(xml['det']).length;
				for (var i = 0; i < Object.keys(xml['det']).length-2; i++) {
					linha += '<tr><td  style="text-align: left" width="50%">0'+xml['det']['@attributes']['nItem']+' '+xml['det']['prod']['cProd']+' '+xml['det']['prod']['xProd']+'</td><td width="1%"> </td><td style="text-align: right" width="49%">'+xml['det']['prod']['vProd']+' X '+qtd['0']+' '+xml['det']['prod']['uCom']+' '+xml['det']['prod']['vItem']+'</td></tr>';
				}
			}
			linha += '<tr><td  style="text-align: left" width="40%">Total bruto dos itens</td><td width="10%"></td><td   style="text-align: right" width="50%">'+xml['total']['ICMSTot']['vProd']+'</td></tr>';
			linha += '<tr><td  style="text-align: left" width="40%">TOTA/L R$</td><td width="10%"></td><td   style="text-align: right" width="50%">'+xml['total']['vCFe']+'</td></tr>';
			linha += '<tr><td  style="text-align: left" width="40%">DINHEIRO</td><td width="10%"></td><td   style="text-align: right" width="50%">'+xml['pgto']['MP']['vMP']+'</td></tr>';
			linha += '<tr><td colspan="3">--------------------------------------------------------</td></tr>';
			linha += '<tr><td colspan="3">'+xml['infAdic']['obsFisco']['xTexto']+'</td></tr>';
			linha += '<tr><td colspan="3">Valor Aproximado dos tributos			  '+xml['total']['vCFeLei12741']+'</td></tr>';
			linha += '<tr><td colspan="3"> </tr>';
			linha += '<tr><td colspan="3">(Conforme Lei Fed. 12.741/2012)</td></tr>';
			linha += '<tr><td colspan="3">--------------------------------------------------------</td></tr>';
			linha += '<tr><td colspan="3">SAT No. '+xml['ide']['nserieSAT']+'</td></tr>';
			var data = xml['ide']['dEmi'];
			data = data.match(/.{1,2}/g);
			var tempo = xml['ide']['hEmi'];
			tempo = tempo.match(/.{1,2}/g);
			linha += '<tr><td colspan="3">'+data['3']+'/'+data['2']+'/'+data['0']+data['1']+' '+tempo['0']+':'+tempo['1']+':'+tempo['2']+'</td></tr>';
			linha += '<tr><td colspan="3"> </td></tr>';
			var numCFe = "n"+xml['@attributes']['Id'];
			numCFe = numCFe.match(/.{1,4}/g);
			numCFe2 = numCFe['1']+numCFe['2']+numCFe['3']+numCFe['4']+numCFe['5']+numCFe['6']+numCFe['7']+numCFe['8']+numCFe['9']+numCFe['10']+numCFe['11'];
			var codebar = numCFe['1']+numCFe['2']+numCFe['3']+numCFe['4']+numCFe['5']+numCFe['6']+numCFe['7']+numCFe['8']+numCFe['9']+numCFe['10']+numCFe['11'];
			codebar = codebar.match(/.{1,22}/g);
			numCFe = numCFe['1']+' '+numCFe['2']+' '+numCFe['3']+' '+numCFe['4']+' '+numCFe['5']+' '+numCFe['6']+' '+numCFe['7']+' '+numCFe['8']+' '+numCFe['9']+' '+numCFe['10']+' '+numCFe['11'];
			linha += '<tr><td colspan="3">'+numCFe+'</td></tr>';

			var codebar1 = JsBarcode("#codebar1", codebar['0'], {
				displayValue:false,
				height: 25
			});
			var codebar2 = JsBarcode("#codebar2", codebar['1'], {
				displayValue:false,
				height: 25
			});

			var options = {
				render: 'div',
				ecLevel: 'L',
				minVersion: 1,

				fill: '#000',
				background: null,

				text: numCFe2+'|'+xml['ide']['dEmi']+xml['ide']['hEmi']+'|'+xml['ide']['mod']+'||'+xml['ide']['assinaturaQRCODE'],
				size: 250,
				radius: 0,
				quiet: 0,

				mode: 0,

				mSize: 0.1,
				mPosX: 0.5,
				mPosY: 0.5,

				label: 'no label',
				fontname: 'sans',
				fontcolor: '#000',

				image: null

			};
		}
		$(linha).appendTo($('#bodyVenda'));
		$('#container').empty().qrcode(options);
		$("#modalVenda").modal('show');
	});
}

function Imprimir(){
	var divToPrint = document.getElementById('tableVenda');
	newWin = window.open("");
	newWin.document.write(divToPrint.outerHTML);
	newWin.print();
	newWin.close();
}
