@extends('delivery.layouts.app')

@section('page-title')
@parent

<small>Clientes</small>

@endsection

@section('content')
<div class="container-fluid">
    <div class="card card-default">
        <div class="card-header">
            <div class="float-right">
                <a href="{{url('/new/delivery/pedidos/create')}}" class="btn btn-delivery text-center" style="color: #fff; background-color: #0163F5; border-color: #0055d4;">
                    <i class="fas fa-plus"></i> Novo
                </a>
            </div>
            <h4>Pedidos</h4>
        </div>
        <div class="card-body">
            <div class="text-left">
                <button href="" class="btn btn-delivery" disabled><i class="fas fa-motorcycle mr-2"></i>Despachar</button>
                <button href="" class="btn btn-danger" disabled><i class="fas fa-times mr-2"></i>Cancelar</button>
            </div>
            <table class="table table-responsive-md">
                <thead>
                    <tr>
                        <th data-check-all="data-check-all">
                            <div class="checkbox c-checkbox text-center" data-toggle="tooltip" data-placement="top" title="" data-original-title="Selecionar Todos" >
                                <label>
                                    <input type="checkbox">
                                    <span class="fa fa-check"></span>
                                </label>
                            </div>
                        </th>
                        <th class="text-left">Pedidos</th>
                        <th class="text-center">Hora do Pedido</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Ação</th>
                    </tr>
                </thead>
                <tbody>


                    <!-- @foreach ($orders as $order) -->
                    <tr>
                        <!-- checkbox -->
                        <td>
                            <div class="checkbox c-checkbox text-center">
                                <label>
                                    <input type="checkbox">
                                    <span class="fa fa-check"></span>
                                </label>
                            </div>
                        </td>
                        <!-- checkbox -->
                        <!-- Pedidos -->
                        <td>
                            <div class="media d-flex align-items-center">
                                @switch($order->engine)
                                @case('IFOOD')
                                <!-- <a class="float-left" href="#"> -->
                                <!-- <img class="img-fluid circle" style="height: 36px !important; width: 36px !important;" src="{{URL::asset('img/ifood.png')}}" alt=""> -->
                                <img class="img-fluid mr-3" style="border-radius: 100%; width: 50px; height: 50px !important;" src="{{URL::asset('img/ifood.png')}}" alt="">
                                <!-- </a> -->
                                @break
                                @case('EPADOCA')
                                <!-- <a class="float-left" href="#"> -->
                                <!-- <img class="img-fluid circle" src="img/epadoca.png" alt=""> -->
                                <img class="img-fluid mr-3" style="border-radius: 100%; width: 50px; height: 50px !important;" src="{{URL::asset('img/epadoca.png')}}" alt="">
                                <!-- </a> -->
                                @break
                                @default
                                <img class="img-fluid mr-3" style="border-radius: 100%; width: 50px; height: 50px !important;" src="{{URL::asset('img/n-delivery.png')}}" alt="">
                                @endswitch
                                <div class="media-body">
                                    <p style="margin-bottom: 0px;">Pedido: #{{$order->idAtendimento}}</p>
                                    @if($order->cliente)
                                    <h4 style="margin-bottom: 3px;">{{$order->cliente}}</h4>
                                    @else
                                    <h4 style="margin-bottom: 3px;">{{$order->customer->stCliente}}</h4>
                                    @endif
                                    <div class="badge bg-gray"><i class="fas fa-map-marker-alt mr-1"></i>{{$order->fullAddress->stEndereco}}, {{$order->fullAddress->nrNumero}}</div>
                                    <!-- <p>{{$order->fullAddress->stEndereco}}, {{$order->fullAddress->nrNumero}}</p> -->
                                    <!-- <p>{{$order->fullAddress}}</p> -->
                                </div>
                            </div>
                        </td>
                        <!-- Pedidos -->
                        <!-- Data e Hora -->
                        <td>
                            <div class="text-center">
                                <p>{{$order->dtAbertura}}</p>
                            </div>
                        </td>
                        <!-- Data e Hora -->
                        <!-- Status -->
                        <td class="text-center">
                            <div class="">
                                @switch($order->stStatus)
                                @case('E')
                                <div class="badge badge-success">Entregue</div>
                                @break
                                @case('S')
                                <div class="badge badge-info">Saiu para Entrega</div>
                                @break
                                @case('P')
                                <div class="badge badge-warning">Pendente</div>
                                @break
                                @endswitch
                            </div>
                        </td>
                        <!-- Status -->
                        <!-- Ação -->
                        <td class="text-center">
                            <div class=""><a href="" class="btn btn-delivery btn-sm"><i class="far fa-edit"></i></a>
                                <a href="" class="btn btn-delivery btn-sm"><i class="fas fa-search"></i></a>
                                <a href="" class="btn btn-delivery btn-sm"><i class="fas fa-print"></i></a></div>
                        </td>
                        <!-- Ação -->
                    </tr>
                    <!-- <tr>
                        {{-- <td>{{ $order->idAtendimento }}</td>--}}
                        {{-- <td>{{ $order->customer }}</td>--}}
                        {{-- <td>{{ $cliente->stCliente }}</td>--}}
                        {{-- <td>--}}
                        {{-- @foreach($cliente->telefones as $telefone)--}}
                        {{-- <span class="mr-1 badge bg-gray">{{$telefone->nrTelefone}}</span>--}}
                        {{-- @endforeach--}}
                        {{-- </td>--}}
                        {{-- @if($cliente->flAtivo)--}}
                        {{-- <td><span class="mr-1 badge badge-success">Ativo </span></td>--}}
                        {{-- @else--}}
                        {{-- <td><span class="mr-1 badge badge-danger" href="">Bloqueado</span></td>--}}
                        {{-- @endif--}}
                    </tr>
                    @endforeach -->
                </tbody>
            </table>
            {{-- {{ $orders->links() }}--}}
        </div>
    </div>

</div>
@endsection()